<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title> <?php echo e(isset($page_title) ? $page_title : ''); ?> | <?php echo e($basic->sitename); ?> </title>
    <!--Favicon add-->
    <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>">
    <!-- bootstrap css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
    <!-- google fonts -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800,900" rel="stylesheet">
    <!-- icofont css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/fonts/icofont/icofont.min.css')); ?>">
    <!-- flaticon css  -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/fonts/flaticon.css')); ?>">
    <!-- font-awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/fontawesome.min.css')); ?>">

    <link href="<?php echo e(asset('assets/admin/css/sweetalert.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/toastr.min.css')); ?>" rel="stylesheet"/>
    <!-- owl-carosel -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/owl.carousel.css')); ?>">
    <!-- animate css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/animate.css')); ?>">
    <!-- style css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
    <?php echo $__env->yieldContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/table.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/color.php')); ?>?color=<?php echo e($basic->color); ?>">
    <!-- responsive css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">

</head>
<body>

<div class="preloader">
    <div class="loader">Loading...</div>
</div>


<header class="header">
    <div class="container">
        <div class="row ">
            <div class="col-lg-1">
                <div class="logo">
                    <a href="<?php echo e(url('/')); ?>" class="logo main-logo">
                        <img src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="logo" style="max-width: 200px;max-height: 40px;">
                    </a>
                </div>
                <div class="menu-button d-block d-xl-none d-lg-block d-md-block d-sm-block">
                    <i class="icofont-navigation-menu"></i>
                </div>
            </div>
            <div class="col-lg-9">
                <div class="main-menu margin-top-20">
                    <ul>
                        <li><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                        <li><a href="<?php echo e(url('/')); ?>">Exchange </a></li>
                        <li><a href="<?php echo e(route('buy')); ?>">Buy </a></li>
                        <li><a href="<?php echo e(route('sell')); ?>">Sell </a></li>

                        <li><a href="#"> Deposit<span><i class="fas fa-angle-down"></i></span></a>
                            <ul>
                                <li><a href="<?php echo e(route('deposit')); ?>">Deposit Money</a></li>
                                <li><a href="<?php echo e(route('user.depositLog')); ?>">Deposit History</a></li>
                            </ul>
                        </li>
                        <li><a href="#"> Withdraw<span><i class="fas fa-angle-down"></i></span></a>
                            <ul>
                                <li><a href="<?php echo e(route('withdraw.money')); ?>">Withdraw Money</a></li>
                                <li><a href="<?php echo e(route('user.withdrawLog')); ?>">Withdraw History</a></li>
                            </ul>
                        </li>



                        <li><a href="#"><?php echo e(Auth::user()->username); ?> <span><i class="fas fa-angle-down"></i></span></a>
                            <ul>
                                <li><a href="<?php echo e(route('user.trx')); ?>">Transaction History</a></li>
                                <li><a href="<?php echo e(route('reference-bonus')); ?>">Reference Bonus</a></li>
                                <li><a href="<?php echo e(route('edit-profile')); ?>">Edit Profile</a></li>
                                <li><a href="<?php echo e(route('user.change-password')); ?>">Change Password</a></li>
                                <li><a href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Sign
                                        Out</a></li>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                      style="display: none;"><?php echo e(csrf_field()); ?></form>
                            </ul>
                        </li>

                    </ul>
                </div>
            </div>

            <div class="col-lg-2 d-flex align-items-center">
                <div class="sign-in">
                    <a href="<?php echo e(route('login')); ?>"><?php echo e(number_format(Auth::user()->balance, $basic->decimal)); ?> <?php echo e($basic->currency); ?></a>
                </div>
            </div>


        </div>
    </div>
</header>


<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>


<!-- jquery js -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/jquery.min.js"></script>
<!-- bootstrap js -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/bootstrap.min.js"></script>
<?php echo $__env->yieldContent('script'); ?>
<script src="<?php echo e(asset('assets/admin/js/toastr.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/sweetalert.js')); ?>"></script>
<!-- owl carosel -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/owl.carousel.js"></script>
<!-- filterizer -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/jquery.filterizr.min.js"></script>
<!-- wow js -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/wow.min.js"></script>
<!-- main js -->
<script src="<?php echo e(asset('assets/front/js/')); ?>/main.js"></script>
<?php echo $__env->yieldContent('js'); ?>
<?php if(session('success')): ?>
    <script type="text/javascript">
        $(document).ready(function () {
            swal("Success!", "<?php echo e(session('success')); ?>", "success");
        });
    </script>
<?php endif; ?>

<?php if(session('alert')): ?>
    <script type="text/javascript">
        $(document).ready(function () {
            swal("Sorry!", "<?php echo e(session('alert')); ?>", "error");
        });
    </script>
<?php endif; ?>
</body>
</html>
