<?php $__env->startSection('content'); ?>
     <div class="nk-content nk-content-fluid">
                        <div class="container-xl wide-lg">
                            <div class="nk-content-body">
                                <div class="nk-block-head">
                                    <div class="nk-block-head-sub"><span>Blockchain Wallet</span></div>
                                    <div class="nk-block-between-md g-4">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title fw-normal"><?php echo e($coin->name); ?> Wallet</h4>
                                            <div class="nk-block-des"><p>Here is the list of your <?php echo e($coin->name); ?> assets / wallets!</p></div>
                                        </div>

                                    </div>
                                </div>
                                <div class="nk-block">
                                    <div class="nk-block-head-sm">
                                        <div class="nk-block-head-content"><h5 class="nk-block-title title"><?php echo e($coin->name); ?> Accounts</h5></div>
                                    </div>
                                    <div class="row g-gs">
                                    <?php if(count($wallet) > 0): ?>
                                    <?php $__currentLoopData = $wallet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <div class="col-sm-6 col-lg-4 col-xl-6 col-xxl-4">
                                            <div class="card card-bordered is-dark">
                                                <div class="nk-wgw">
                                                    <div class="nk-wgw-inner">
                                                        <a class="nk-wgw-name" href="<?php echo e(route('viewwallet',$data->address)); ?>">
                                                            <div class="nk-wgw-icon is-default"><em class="icon ni ni-<?php echo e($coin->symbol); ?>"></em></div>
                                                            <h5 class="nk-wgw-title title"><?php echo e($coin->name); ?></h5>
                                                        </a>
                                                        <div class="nk-wgw-balance">
                                                            <div class="amount"><?php echo e($data->balance); ?><span class="currency currency-nio"> <?php echo e($coin->currency); ?></span></div>
                                                            <div class="amount-sm"><?php echo e(number_format($coin->price * $data->balance, $basic->decimal)); ?> <span class="currency currency-usd">USD</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="nk-wgw-actions">
                                                        <ul>
                                                            <li>
                                                                <a href="#"><em class="icon ni ni-scan"></em> <span><?php echo e($data->address); ?></span></a>
                                                            </li>

                                                        </ul>
                                                    </div>
                                                    <div class="nk-wgw-more dropdown">
                                                        <a href="#" class="btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                        <div class="dropdown-menu dropdown-menu-xs dropdown-menu-right">
                                                            <ul class="link-list-plain sm">
                                                                <li><a href="<?php echo e(route('viewwallet',$data->address)); ?>">Details</a></li>

                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                          <div class="col-sm-6 col-lg-4 col-xl-6 col-xxl-4">
                                            <div class="card card-bordered is-dark">
                                                <div class="nk-wgw">
                                                    <div class="nk-wgw-inner">
                                                        <a class="nk-wgw-name" href="#">
                                                            <div class="nk-wgw-icon  "><em class="icon ni ni-wallet-alt"></em></div>
                                                            <h5 class="nk-wgw-title title">No Wallet Yet</h5>
                                                        </a>
                                                        <div class="nk-wgw-balance">
                                                            <div class="amount">0.00<span class="currency currency-nio"></span></div>
                                                            <div class="amount-sm">0.00<span class="currency currency-usd">USD</span></div>
                                                        </div>
                                                    </div>
                                                    <div class="nk-wgw-actions">
                                                        <ul>
                                                            <li>
                                                                <a href="#"><em class="icon ni ni-wallet"></em> <span>No Wallet Address</span></a>
                                                            </li>

                                                        </ul>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>

                                         <div class="col-md-6 col-lg-4">
                                            <div class="card card-bordered dashed h-100">
                                                <div class="nk-wgw-add">
                                                    <div class="nk-wgw-inner">
                                                        <a href="<?php echo e(route('createwallet',$id)); ?>">
                                                            <div class="add-icon"><em class="icon ni ni-plus"></em></div>
                                                            <h6 class="title">Add New Wallet</h6>
                                                        </a>
                                                        <span class="sub-text">You can add your more wallet in your account to manage separetly.</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('include.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>